module projectAdmin

import StdEnv, StdiData, GenEq

derive gForm 	[], ProjectForm, Admin, Budget, DateName, Duration, Extension, Grant, Maybe, ProjectStatus, YesNo
derive gUpd 	[], ProjectForm, Admin, Budget,DateName, Duration, Extension, Grant, Maybe, ProjectStatus, ToDay, YesNo
derive gParse 		ProjectForm, Admin, Budget,DateName, Duration, Extension, Grant, Maybe, ProjectStatus, ToDay, YesNo
derive gPrint 		ProjectForm, Admin, Budget,DateName, Duration, Extension, Grant, Maybe, ProjectStatus, ToDay, YesNo
derive gerda 		ProjectForm, Admin, Budget,DateName, Duration, Extension, Grant,  ProjectStatus, ToDay, YesNo

:: ProjectForm 
	= 	{ projectNumber	:: String
		, projectName	:: String
		, grantSupplier	:: String
		, projectLeader	:: String
		, dosierMadeOn	:: DateName
		, administrated	:: Maybe (Admin,DateName)
		, status		:: ProjectStatus 
		, dosierChecked	:: Maybe DateName
		, dosierCleared	:: Maybe DateName
		}
:: DateName 
	=	{ date			:: ToDay
		, name			:: String
		, remarks		:: Maybe TextArea
		} 
:: Admin
	=	Airbase
	|	MIS
	|	XYZ
:: ProjectStatus
	=	Granted 		Grant DateName 
	|	Denied			DateName
	|	InProcess 		Budget
	|	Empty	
:: Grant
	=	{ amount		:: Int
		, duration		:: Duration
		, vat			:: YesNo
		, extension		:: Maybe Extension
		}
:: Duration 
	=	{ startDate		:: HtmlDate
		, endDate		:: HtmlDate
		, remarks		:: Maybe TextArea
		} 
:: YesNo
	=	Yes
	|	No
:: Extension
	=	ExtGranted 		DateName
	| 	ExtAsked		DateName
:: Budget
	=	{ budget		:: (Int,DateName)
		, approved		:: Maybe DateName
		}
:: ToDay
	= ToDay HtmlDate

gForm{|ToDay|} (init,formid) hst = specialize myedit (init,formid) hst
where
	myedit (init,formid) hst
	# ((time,today),hst) 	= getTimeAndDate hst
	# (form,hst) 			= gForm{|*|} (init,{formid & ival = today} <@ Display <@ Session) hst
	= ({form & value 		= ToDay form.value},hst)

Start world = doHtmlServer (multiUserTask 2 (repeatTask projectAdmin)) world

initProject :: ProjectForm
initProject = createDefault

projectAdmin
=	[]
	?>> chooseTask 
		[ ("NewProject", newproject)
		, ("OpenProject",openproject)
		]
where
	newproject 
	= 					editTask "Change" initProject <<@ Submit	
		=>> \ndbval	->	appHSt (storeDB -1 ndbval)

	openproject
	= 					appHSt openDB
		=>> \dbval 	-> 	[Txt "Which project do want to open?",Br] 
						?>>	editTask "Open" (PullDown (1,100) (0,[rec.projectNumber \\ rec <- dbval]))
		=>> \(PullDown _ (idx,_))
					->	orTask
							(	editTask "Change" (dbval!!idx) <<@ Submit
							,	editTask "Cancel" Void #>> returnV (dbval!!idx) 
							)
		=>> \ndbval -> appHSt (storeDB idx ndbval)



myProjectDB fun hst = mkStoreForm (Init,pFormId "projectAdmin" []) fun hst
openDB hst 			
# (db,hst) = myProjectDB id hst
= (db.value,hst)

storeDB idx project hst
# (db,hst) 	= myProjectDB id hst
# dbval 	= if (idx < 0) [project:db.value] (updateAt idx project db.value)
# (db,hst) 	= myProjectDB (\_ -> dbval) hst
= (db.value,hst)
